# Recording the videos
Background shade of blue is R:198 G:217 B:238
videos are recorded with MacOS ⇧⌘5 screen capture utility
750x275 frame

cursor enters frame in from the lower left at start of each video so that the movement will catch the eye

# file conversion mov to mp4
for file size
just use ffmpeg with default settings `ffmpeg -i input.mov output.mp4`
 
# thumbnails

thumbnail is size 360 60% opacity "▶︎" in Menlo centred on the first frame of video converted to png

`ffmpeg -i input.mov -vf drawtext="fontfile=/System/Library/Fonts/Menlo.ttc: text='▶': fontcolor=black@0.6: fontsize=360: x=(w-text_w)/2: y=(h-text_h)/2" -frames:v 1 output.png`

The font, Menlo is arbitrarily chosen because of its availability. Almost all fonts render the ▶ symbol alike, with minor variation.

# batch convert everything
its easier than doing it one at a time!

- record all the videos
- name them appropriately (access.mov, copy.mov, invoke.mov, link.mov, not-just-finder.mov)
- put them in a folder together
- run the appropriate script to
    + convert mov to mp4
    + create thumbnail
    + move original file to Trash

```in bash or zsh
for file in *.mov; do
    ffmpeg -i "$file" "$(basename "$file" .mov).mp4"
    ffmpeg -i "$file" -vf drawtext="fontfile=/System/Library/Fonts/Menlo.ttc: text='▶': fontcolor=black@0.6: fontsize=360: x=(w-text_w)/2: y=(h-text_h)/2" -frames:v 1 "$(basename "$file" .mov).png"
    mv "$file" ~/.Trash
done
```

```in fish
for file in (ls *.mov)
    ffmpeg -i $file (basename $file .mov).mp4
    ffmpeg -i $file -vf drawtext="fontfile=/System/Library/Fonts/Menlo.ttc: text='▶': fontcolor=black@0.6: fontsize=360: x=(w-text_w)/2: y=(h-text_h)/2" -frames:v 1 (basename "$file" .mov).png
    mv $file ~/.Trash
end
```

# the clips

All the clips (except invoke.mp4) are all filmed against the right edge of the screen, to force the contextual title menu to appear within the window frame, otherwise it appears to the right of the button.

Run Hook.app from the binary, not fom XCode, because it runs more snappily.

## invoke.mp4
Keystrokes were shown with a program called "KeyStroke Pro", licensed to grrraham@gmail.com key: 10908272-8B434318-9B0ACAAC-1FCD3446

Have to  configure Hookmark to use a different hotkey to invoke, because if Hookmark is assigned to ⌘⇧SPACE, it will catch the keystroke and KeyStroke Pro won't receive the final spacebar. 
So assign Hookmark to ⌘⇧M, and press ⌘⇧SPACE and then quickly, while still holding down ⌘⇧, press M.

## copy.mp4
disable "Check spelling as you type" in TextEdit>Preferences so that there isn't a red underline under portions of pasted URL

## access.mp4
the TextEdit window is positioned and then hidden (⌘H) not closed, before recording, so that it will be in the correct spot when it is opened
